### 实验目的

掌握使用HBase 过滤器进行全表扫描

### 实验背景

基于Ubuntu 18.04下使用Hbase2.4.17实现过滤器操作

### 实验原理

在HBase中，Get和Scan操作都可以使用过滤器来设置输出的范围，类似于SQL里面的Where查询条件。使用show\_filter命令可以查看当前HBase支持的过滤器类型：

![allfilter.png](./pic/allfilter.png)

使用上述过滤器时，一般需要配合比较运算符或比较器共同使用，如下图所示：

![运算符和比较器.png](./pic/运算符和比较器.png)

### 实验环境

Ubuntu 18.04

JDK 1.8

Hadoop 3.3.5

Hbase 2.4.17

### 建议课时

6课时

### 实验步骤

**一：实验前准备**

1、打开终端

双击桌面上terminal图标，打开操作终端

![terminal.png](./pic/terminal.png)

2、启动hadoop及Hbase

我们需要进入 hadoop目录下的sbin文件夹中。

```markup
cd /opt/hadoop/sbin/
```

初始化namenode：

```markup
hdfs namenode -format
```

启动hdfs：

```markup
./start-all.sh
```

使用start-hbase.sh命令启动hbase

```markup
cd /opt/hbase/bin/
./start-hbase.sh 
```

使用hbase shell命令来连接正在运行的Hbase实例，该命令位于HBase安装包下的bin/目录。HBase Shell提示符以>符号结束。

```markup
./hbase shell
```

3.在使用过滤器之前先创建这样的表结构：

![数据表.png](./pic/数据表.png)

具体执行命令如下：

创建表：

```markup
create 'student','stuInfo','grades'
```

插入第一个逻辑行的数据：

```markup
put 'student', '001', 'stuInfo:name','alice'

put 'student', '001', 'stuInfo:age','18'

put 'student', '001', 'stuInfo:sex','female'

put 'student', '001', 'grades:english','80'

put 'student', '001', 'grades:math','90'
```

插入第二个逻辑行的数据：

```markup
put 'student', '002', 'stuInfo:name','nancy'

put 'student', '002', 'stuInfo:sex','male'

put 'student', '002', 'stuInfo:class','1802'

put 'student', '002', 'grades:english','85'

put 'student', '002', 'grades:math','78'

put 'student', '002', 'grades:bigdata','88'
```

插入第三个逻辑行的数据：

```markup
put 'student', '003', 'stuInfo:name','harry'

put 'student', '003', 'stuInfo:age','19'

put 'student', '003', 'stuInfo:sex','male'

put 'student', '003', 'stuInfo:class','1803'

put 'student', '003', 'grades:english','90'

put 'student', '003', 'grades:bigdata','90'
```

**二：过滤器操作**

1．行键过滤器

包括RowFilter、PrefixFilter、KeyOnlyFilter、FirstKeyOnlyFilter等

格式：scan ‘表名’，{Filter =>“过滤器( 比较运算符，’比较器’)”}

（1）RowFilter：针对行键进行过滤

例1：显示行键前缀为0开头的键值对；

```markup
scan 'student',{FILTER=>"RowFilter(=,'substring:001')"}
```

例2：显示行键字节顺序大于002的键值对；

```markup
scan 'student',FILTER=>"RowFilter(>,'binary:002')"
```

### **![Rowfilter.png](./pic/Rowfilter.png)**

（2）PrefixFilter：行键前缀过滤器

例3：扫描前缀为001的行键

```markup
scan 'student',FILTER=>"PrefixFilter('001')"
```

（3）FirstKeyOnlyFilter：扫描全表，显示每个逻辑行的第一个键值对

例4： 

```markup
scan 'student',FILTER=>"FirstKeyOnlyFilter()"
```

![prefixfilter.png](./pic/prefixfilter.png)

（4）InclusiveStopFilter：替代ENDROW返回终止条件行；

例5：扫描显示行键001到002范围内的键值对

```markup
scan 'student', {STARTROW =>'001',FILTER =>"InclusiveStopFilter('002')"}
```

此条命令等同于：

```markup
scan 'student', {STARTROW =>'001',ENDROW => '003'}
```

![inclusivestopfilter.png](./pic/inclusivestopfilter.png)

2．列族与列过滤器

（1）FamilyFilter：针对列族进行比较和过滤。

例1：显示列族前缀为stu开头的键值对；

```markup
scan 'student',FILTER=>"FamilyFilter(=,'substring:stu')"

scan 'student',FILTER=>"FamilyFilter(=,'binary:stu')"
```

![familyfilter.png](./pic/familyfilter.png)

（2）QualifierFilter：列标识过滤器。

例2：显示列名为name的记录；

```markup
scan 'student',FILTER=>"QualifierFilter(=,'substring:name')"
```

![qualifilterfilter.png](./pic/qualifilterfilter.png)

（3）ColumnPrefixFilter：对列名前缀进行过滤。

例2：显示列名为name的记录；

```markup
 scan 'student',FILTER=>"ColumnPrefixFilter('name')"
```

等价于

```markup
scan 'student',FILTER=>"QualifierFilter(=,'substring:name')"
```

（4）MultipleColumnPrefixFilter：可以指定多个前缀

例3：显示列名为name和age的记录；

```markup
scan 'student',FILTER=>"MultipleColumnPrefixFilter('name','age')"
```

（5）ColumnRangeFilter ：设置范围按字典序对列名进行过滤；

```markup
scan 'student',FILTER=>"ColumnRangeFilter('bi',true,'na',true)"
```

![columnrange.png](./pic/columnrange.png)

3．值过滤器

（1）ValueFilter ：值过滤器。

例1：查询值等于19的所有键值对

```markup
scan 'student',FILTER=>"ValueFilter(=,'binary:19') "
scan 'student',FILTER=>"ValueFilter(=,'substring:19')"
```

（2）SingleColumnValueFilter ：在指定的列族和列中进行值过滤器。

例2：查询stuinfo列族age列中值等于19的所有键值对

```markup
scan 'student',{COLUMN=>'stuInfo:age',FILTER=>"SingleColumnValueFilter('stuInfo','age',=,'binary:19')"}
```

![singlecolumn.png](./pic/singlecolumn.png)

4．其他过滤器

（1）ColumnCountGetFilter ：限制每个逻辑行返回的键值对数

例1：返回行键为001的前3个键值对

```markup
get 'student','001',FILTER=>"ColumnCountGetFilter(3)"
```

![columncount.png](./pic/columncount.png)

（2）PageFilter ：基于行的分页过滤器，设置返回行数。

例2：显示一行

```markup
scan 'student',FILTER=>"PageFilter(1)"
```

![pagefilter.png](./pic/pagefilter.png)

（3）ColumnPaginationFilter ：基于列的进行分页过滤器，需要设置偏移量与返回数量 。

例3：显示每行第1列之后的2个键值对

```markup
scan 'student',FILTER=>"ColumnPaginationFilter(2,1)"
```

### 实验总结

通过本次实验，掌握了Ubuntu下Hbase 过滤器的操作。